<?php

// require the setup which has registered the autoloader
require_once __DIR__ . '/setup.php';

// CREATE THE ENDPOINT
$endpoint = new EmsApi\Endpoint\TransactionalEmails();

/*===================================================================================*/

// GET ALL ITEMS
$response = $endpoint->getEmails($pageNumber = 1, $perPage = 10);

// DISPLAY RESPONSE
echo '<pre>';
print_r($response->body);
echo '</pre>';

/*===================================================================================*/

// GET ONE ITEM
$response = $endpoint->getEmail('EMAIL-UNIQUE-ID');

// DISPLAY RESPONSE
echo '<hr /><pre>';
print_r($response->body);
echo '</pre>';

/*===================================================================================*/

// delete email
$response = $endpoint->delete('EMAIL-UNIQUE-ID');

// DISPLAY RESPONSE
echo '<hr /><pre>';
print_r($response->body);
echo '</pre>';

/*===================================================================================*/

// CREATE A NEW EMAIL
$response = $endpoint->create([
    'to_name'           => 'John Doe', // required
    'to_email'          => 'john@doe.com', // required
    'from_name'         => 'Jane Doe', // required
    'from_email'        => 'jane@doe.com', // optional
    'reply_to_name'     => 'Jane Doe', // optional
    'reply_to_email'    => 'jane@doe.com', // optional
    'subject'           => 'This is the email subject', // required
    'body'              => '<strong>Hello world!</strong>', // required
    'plain_text'        => 'Hello world!', // optional, will be autogenerated if missing
    'send_at'           => date('Y-m-d H:i:s'),  // required, UTC date time in same format!
    'attachments'       => [
        [
            'type' => 'image/png',
            'name' => basename(__DIR__ . '/PATH_TO_YOUR_FILE/file.png'),
            'data' => base64_encode((string)file_get_contents(__DIR__ . '/PATH_TO_YOUR_FILE/file.png')),
        ],
        [
            'type' => 'image/jpeg',
            'name' => basename(__DIR__ . '/PATH_TO_YOUR_FILE/file.jpg'),
            'data' => base64_encode((string)file_get_contents(__DIR__ . '/PATH_TO_YOUR_FILE/file.jpg')),
        ],
        [
            'type' => 'application/pdf',
            'name' => basename(__DIR__ . '/PATH_TO_YOUR_FILE/file.pdf'),
            'data' => base64_encode((string)file_get_contents(__DIR__ . '/PATH_TO_YOUR_FILE/file.pdf')),
        ],
    ]
]);

// DISPLAY RESPONSE
echo '<hr /><pre>';
print_r($response->body);
echo '</pre>';

/*===================================================================================*/
