<?php if ( ! class_exists('BounceHandler', false)) exit('No direct script access allowed');

return array(
	BounceHandler::DIAGNOSTIC_CODE_RULES => array(),
	BounceHandler::DSN_MESSAGE_RULES     => array(),
	BounceHandler::BODY_RULES            => array(),
	BounceHandler::COMMON_RULES          => array(
		array(
			'bounceType' => BounceHandler::BOUNCE_INTERNAL,
			'regex'		 => array(
				'/smtp;(\s*)?550(.*)?Unfortunately, messages from (.*) weren\'t sent/i',
				'/smtp;(\s*)?554 ERROR: Mail Refused/i',
				'/smtp;(\s*)?(550|554)(.*)?Service unavailable/i',
				'/smtp;(\s*)?553 https:\/\/www\.spamhaus\.org\/sbl\/query\/SBLCSS/i',
				'/smtp;(\s*)?554 Message rejected for policy reasons/i',
				'/smtp;(\s*)?554(.*)?IP address is black(\s)?listed/i',
				'/smtp;(\s*)?554(.*)?poor reputation/i',
				'/smtp;(\s*)?550 Your IP (.*)?is in RBL/i',
				'/smtp;(\s*)?522 IP FOUND IN DNSRBL/i',
				'/smtp;(\s*)?550 X-Warning: (.*)?is in a black(\s)?list at (.*)/i',
				'/smtp;(\s*)?(550|552|554) spam ((e)?mail|message) rejected(.*)?/i',
				'/smtp;(\s*)?554 IP=(.*) - A problem occurred/i',
				'/smtp;(\s*)?554 Blocked - see/i',
				'/smtp;(\s*)?550 REJ-RELAY-001: relay not permitted/i',
				'/smtp;(\s*)?550(.*)?blocked for spamming issues/i',
				'/smtp;(\s*)?553(.*)?DNSBL/i',
				'/smtp;(\s*)?554(.*)?Mail contains unique UBE\/UCE characteristics/i',
				'/smtp;(\s*)?554(.*)?ESMTP Blocked/i',
				'/smtp;(\s*)?550(.*)?Access denied, banned sending IP/i',
				'/smtp;(\s*)?501 Connection rejected by policy/i',
				'/smtp;(\s*)?550 ([a-z0-9]{40,})/i',
				'/smtp;(\s*)?550 This message was classified as SPAM/i',
				'/smtp;(\s*)?554 mx686\.syd\.oss-core\.com/i',
				'/smtp;(\s*)?554(.*)?spam detected/i',
				'/smtp;(\s*)?554(.*)?Message blocked due to spam content in the message/i',
				'/smtp;(\s*)?550(.*)?Rejected - confirmed junk email/i',
				'/smtp;(\s*)?550 Administrative prohibition/i',
				'/smtp;(\s*)?550 Your email has not been delivered as it violates/i',
				'/smtp;(\s*)?(554|550) (Denied|Rejected)/i',
				'/smtp;(\s*)?550(.*)?Message detected as spam/i',
				'/smtp;(\s*)?550(.*)?IP address refused/',
				'/smtp;(\s*)?550(.*)?Poor Reputation Sender/i',
				'/smtp;(\s*)?554(.*)?Please submit an unblock request/i',
				'/smtp;(\s*)?554(.*)?You are not allowed to connect/i',
				'/smtp;(\s*)?554 Mail from (.*)?refused, see RBL server/i',
				'/smtp;(\s*)?571(.*)?Message contains spam or virus or sender is blocked/i',
				'/smtp;(\s*)?554(.*)?found on one or more DNSBLs, see/i',
				'/smtp;(\s*)?550(.*)?RBL Restriction/i',
				'/smtp;(\s*)?571 Email from (.*)?is currently blocked by/i',
				'/smtp;(\s*)?451 Could not load DRD for domain/i',
				'/smtp;(\s*)?450 Service temporarily unavailable; Client host (.*)?blocked using/i',
				'/smtp;(\s*)?554(.*)?Client host (.*)?blocked using/i',
				'/smtp;(\s*)?554(.*)?Spam content found/i',
				'/smtp;(\s*)?550 Recipient Rejected: Access Denied/i',
				'/smtp;(\s*)?550(.*)?Mail rejected/i',
				'/smtp;(\s*)?554(.*)?BLACKLIST/i',
				'/smtp;(\s*)?550(.*)?ALERTA/i',
				'/smtp;(\s*)?554(.*)?(unsolicited email|untrusted mail delivery system)/i',
				'/smtp;(\s*)?554 \(RTR:BL\)/i',
				'/smtp;(\s*)?550(.*)?Sorry, message looks like spam or phish/i',
				'/smtp;(\s*)?554(.*)?RBL Reject/i',
				'/smtp;(\s*)?553(.*)?DNSBL:ATTRBL/i',
				'/smtp;(\s*)?550(.*)?has been rejected/i',
				'/smtp;(\s*)?550 A URL in this email/i',
				'/smtp;(\s*)?550(.*)?IP has been found on a block(\s)?list/i',
				'/smtp;(\s*)?550(.*)?is blocked by/i',
				'/smtp;(\s*)?550(.*)?IP address is administratively disabled/i',
				'/smtp;(\s*)?554(.*)?rejected due to the bad reputation/i',
				'/smtp;(\s*)?550 Message refused by/i',
				'/smtp;(\s*)?554(.*)?Access denied/i',
				'/SMTP;(\s*)?550(.*)?Message considered as spam or virus, rejected/i',
				'/smtp;(\s*)?550(.*)?Access denied/i',
				'/smtp;(\s*)?550(.*)?is not allowed to send mail from/i',
				'/smtp;(\s*)?550 "JunkMail rejected/i',
				'/smtp;(\s*)?550(.*)?Connection rejected. Your IP (.*) is in RBL/i',
				'/smtp;(\s*)?550(.*)?SPAM/i',
				'/smtp;(\s*)?554(.*)?Spam content found/i',
				'/smtp;(\s*)?554(.*)?Connection refused/i',
				'/smtp;(\s*)?550 MFE: Message detected as spam/i',
				'/smtp;(\s*)?550 you are not allowed to send mail to/i',
				'/smtp;(\s*)?554(.*)?You are not allowed to send mail/i',
				'/smtp;(\s*)?550(.*)?Message considered as spam or virus/i',
				'/smtp;(\s*)?554(.*)?Your IP (.*)?address has a bad reputation/i',
				'/smtp;(\s*)?554(.*)?Service not available No SMTP service IP address is black(\s)?listed/i',
				'/smtp;(\s*)?550 High probability of spam/i',
				'/smtp;(\s*)?554(.*)?Please revise your message before resending./i',
				'/smtp;(\s*)?554 message refused by/i',
				'/smtp;(\s*)?552(.*)?spam message rejected/i',
				'/smtp;(\s*)?550(.*)?Cyren AntiSpam/i',
				'/smtp;(\s*)?571(.*)?Delivery not authorized, message refused/i',
				'/smtp;(\s*)?550(.*)?Poor Reputation Sender/i',
				'/smtp;(\s*)?550(.*)?Recipients have complained about included content/i',
				'/smtp;(\s*)?553(.*)?Message filtered/i',
				'/smtp;(\s*)?554(.*)?Sender denied/i',
				'/smtp;(\s*)?554(.*)?(cloudmark|blocked)/i',
				'/smtp;(\s*)?554(.*)?message (expired|timeout)/i',
				'/smtp;(\s*)?550(.*)?Spam Detected/i',
				'/smtp;(\s*)?550(.*)?Server IP blacklisted/i',
				'/smtp;(\s*)?553(.*)?has been denied/i',
				'/smtp;(\s*)?554(.*)?The message from/i',
				'/smtp;(\s*)?554(.*)?Client host rejected/i',
				'/smtp;(\s*)?554(.*)?message timeout/i',
				'/smtp;(\s*)?550(.*)?is blocked by/i',
				'/smtp;(\s*)?550(((?!(permanent failure)).)*)Blocked/i',
				'/smtp;(\s*)?550(.*)?Sending too fast/',
				'/smtp;(\s*)?550(.*)?Envelope blocked/i',
				'/smtp;(\s*)?550(.*)?Mail from (.*)? has been blocked by/i',
				'/smtp;(\s*)?554(.*)?Hop count exceeded - possible mail loop/i',
				'/smtp;(\s*)?550(.*)?Message rejected as spam/i',
				'/smtp;(\s*)?421(.*)?SMTP service not available/i',
				'/smtp;(\s*)?503(.*)?Error: need MAIL command/i',
				'/smtp;(\s*)?554(.*)?Too many hops/i',
				'/smtp;(\s*)?554(.*)?mail rejected due to account:(.*)?already has attempted to use/i',
				'/smtp;(\s*)?550(.*)?the message was rejected by organization policy/i',
				'/smtp;(\s*)?550(.*)?message expired/i',
				'/smtp;(\s*)?553(.*)?All messages from (.*)? will be permanently deferred; Retrying will NOT succeed/i',
				'/smtp;(\s*)?554(.*)?rejecting banned content/i',
				'/smtp;(\s*)?554(.*)?(Email|Message) rejected due to (security|local) (policy|policies)/i',
				'/smtp;(\s*)?554(.*)?E?SMTP not accepting connections/i',
				'/(smtp;(\s*)?)?550(.*)?does not pass DMARC verification and has a DMARC policy/i',
				'/delivery temporarily suspended/i',
				'/Service unavailable/i',
				'/delivery failed; will not continue trying/i',
				'/Message content rejected/i',
				'/X-Unix; 1/i',
				'/x-pmta;no compatible source IP configured/i',
				'/X-Postfix; mail for (.*)?loops back to myself/i',
				'/A url in this (.*)?is (black)?listed/i',
				'/ip address in blacklist/i',
				'/blacklisted by CSI/i',
				'/reject by behaviour spam/i',
				'/DNSBL record found/i',
				'/You are not allowed to send mail/i',
				'/spamhaus/i',
				'/FORBIDDEN/i',
				'/temporarily deferred/i',
				'/block for spam/i',
				'/blocked \- Error Code: CDRBL \- Refer to Error Codes section/i',
				'/Our system has detected/i',
				'/Connection (time(d)? out|refused)/i',
				'/prevents additional messages from being delivered/i',
				'/Lock failure on/i',
				'/could not connect and send the mail/i',
				'/could not connect to DNS/i',
				'/procmail: Error while writing to/i',
				'/temporarily rate limited due to/i',
				'/X-Postfix; TLS is required, but was not offered by host/i',
				'/X-Postfix; mail transport unavailable/i'
			),
		),
		array(
			'bounceType' => BounceHandler::BOUNCE_SOFT,
			'regex'      => array(
				'/(over|exceed).*quota/i',
				'/(?:alias|account|recipient|address|email|mailbox|user).*full/i',
				'/Insufficient system storage/i',
				'/File too large/i',
				'/larger than.*limit/i',
				'/System.*busy/i',
				'/Resources temporarily unavailable/i',
				'/Temporary local problem/i',
				'/delivery.*suspend/i',
				'/over.*quota/i',
				'/quota.*exceeded/i',
				'/exceed.*?.*quota/i',
				'/space.*not.*enough/i',
				'/.*?.*?.*over.*quota/i',
				'/quota exceeded.*?.*/i',
				'/.*?.*quota exceeded/i',
				'/.*?.*mailbox.*full/i',
				'/The message to .*bounce.*Quota exceed/i',
				'/.*?.*?.*Resources temporarily unavailable/i',
				'/^AutoReply message from /i',
				'/(user\shas\s)?exceeded(\s+storage\sallocation)?/i',
				'/mail(box|folder)(\s+)?(is|full|quota|size)(\s+)?(full|usage|limit)?(\s+)?(exceeded)?/i',
				'/quota\s(full|violation)/i',
				'/User\s(has|mail(box|folder))\s+((exhausted|exceeds)\sallowed\s(size|.*space)|(too\smany.*server))/i',
				'/delivery\s(temporarily\ssuspended|attempts\swill\scontinue\sto\sbe\smade\sfor)/i',
				'/user mailbox is (inactive|expired)/i',
				'/user account disabled/i',
				'/User is inactive/i',
				'/inactive user/i',
				'/extended inactivity new mail is not currently being accepted/i',
				'/mailbox temporarily disabled/i',
				'/Blocked address/i',
				'/Account (inactive|expired)(\sas\sunread)?/i',
				'/User hasn\'t entered during last/i',
				'/Account closed due to inactivity/i',
				'/This account is not allowed/i',
				'/Mailbox_currently_suspended/i',
				'/Mailbox disabled/i',
				'/quota exceeded/i',
				'/user is over quota/i',
				'/exceeds size limit/i',
				'/user has full mailbox/i',
				'/Mailbox disk quota exceeded/i',
				'/over the allowed quota/i',
				'/User mailbox exceeds allowed size/i',
				'/does not have enough space/i',
				'/mailbox is full/i',
				'/mailbox full/i',
				'/File too large/i',
				'/too many messages (on|in) this mailbox/i',
				'/Not enough storage space/i',
				'/Over quota/i',
				'/over the maximum allowed number of messages/i',
				'/Recipient exceeded email quota/i',
				'/The user has not enough diskspace available/i',
				'/Mailbox has exceeded the limit/i',
				'/exceeded storage allocation/i',
				'/Quota violation/i',
				'/522_mailbox_full/i',
				'/account is full/i',
				'/incoming mailbox for user/i',
				'/message would exceed quota/i',
				'/recipient exceeded dropfile size quota/i',
				'/not able to receive any more mail/i',
				'/user is invited to retry/i',
				'/User account is overquota/i',
				'/mailfolder is full/i',
				'/exceeds allowed message count/i',
				'/message is larger than the space available/i',
				'/recipient storage full/i',
				'/The user\'s space has used up/i',
				'/user is over their quota/i',
				'/exceed the quota for the mailbox/i',
				'/exceed maximum allowed storage/i',
				'/Inbox is full/i',
				'/over quota/i',
				'/maildir has overdrawn his diskspace quota/i',
				'/disk full/i',
				'/Quota exceed(ed)?/i',
				'/Storage quota reached/i',
				'/user overdrawn his diskspace quota/i',
				'/exceeded his\/her quota/i',
				'/quota for the mailbox/i',
				'/The incoming mailbox for user/i',
				'/exceeded the space quota/i',
				'/mail box space not enough/i',
				'/insufficient disk space/i',
				'/over their disk quota/i',
				'/Message would exceed/i',
				'/User is overquota/i',
				'/Requested mailbox exceeds quota/i',
				'/exceed mailbox quota/i',
				'/over the storage quota/i',
				'/over disk quota/i',
				'/mailbox_quota_exceeded/i',
				'/over the maximum allowed mailbox size/i',
				'/Delivery failed: Over quota/i',
				'/550 Rule imposed mailbox access for/i',
				'/they are not accepting mail/i',
				'/not capable to receive mail/i',
				'/Can\'t open mailbox/i',
				'/Delivery failed 1 attempt/i',
				'/Resources temporarily unavailable/i',
				'/error on maildir delivery/i',
				'/this message has been in the queue too long/i',
				'/Temporary error on maildir delivery/i',
				'/delivery temporarily suspended/i',
				'/Undeliverable message/i',
				'/user path(\sdoes)? no(t)? exist/i',
				'/maildir delivery failed/i',
				'/Resources temporarily not available/i',
				'/has exceeded the max emails per hour/i',
				'/unable to deliver a message to/i',
				'/Remote host said: (542 Rejected|554 Failure)/i',
				'/The user\'s space has used up/i',
				'/exceeded his\/her quota/i',
				'/Message would exceed/i',
				'/.*?.*?.*user is inactive/i',
				'/.*inactive account/i',
				'/mailbox is currently unavailable/i',
				'/Invalid User/i',
				'/Mailaddress is administratively disabled/i',
				'/Mailbox currently suspended/i',
				'/Account has been suspended/i',
				'/account is not active/i',
				'/recipient never logged onto/i',
				'/account has been temporarily suspended/i',
				'/deactivated mailbox/i',
				'/disabled due to inactivity/i',
				'/not an active address/i',
				'/inactive on this domain/i',
				'/account is locked/i',
				'/account deactivated/i',
				'/disabled mailbox/i',
				'/Mailaddress is administrativley disabled/i',
				'/is disabled/i',
				// added 1.3.6
				'/DNS reverse lookup failed/i',
				'/Reverse DNS for/i',
				'/Poor Reputation Sender/i',
				'/Recipient address rejected: Blacklisted by/i',
				'/553 5\.7\.1/i',
				'/571 5\.0\.0/i',
			),
		),
		array(
			'bounceType' => BounceHandler::BOUNCE_HARD,
			'regex' => array(
				'/smtp; 550 permanent failure for one or more recipients/i',
				'/(?:alias|account|recipient|address|email|mailbox|user)(.*)not(.*)list/i',
				'/user path no exist/i',
				'/no.*valid.*(?:alias|account|recipient|address|email|mailbox|user)/i',
				'/Invalid.*(?:alias|account|recipient|address|email|mailbox|user)/i',
				'/(?:alias|account|recipient|address|email|mailbox|user).*(?:disabled|discontinued)/i',
				'/user doesn\'t have.*account/i',
				'/(?:unknown|illegal).*(?:alias|account|recipient|address|email|mailbox|user)/i',
				'/(?:alias|account|recipient|address|email|mailbox|user).*(?:un|not\s+)available/i',
				'/no (?:alias|account|recipient|address|email|mailbox|user)/i',
				'/(?:alias|account|recipient|address|email|mailbox|user).*unknown/i',
				'/No such (?:alias|account|recipient|address|email|mailbox|user)/i',
				'/(?:alias|account|recipient|address|email|mailbox|user).*NOT FOUND/i',
				'/deactivated (?:alias|account|recipient|address|email|mailbox|user)/i',
				'/(?:alias|account|recipient|address|email|mailbox|user).*reject/i',
				'/bounce.*administrator/i',
				'/<.*>.*disabled/i',
				'/not our customer/i',
				'/Wrong (?:alias|account|recipient|address|email|mailbox|user)/i',
				'/(?:unknown|bad).*(?:alias|account|recipient|address|email|mailbox|user)/i',
				'/(?:alias|account|recipient|address|email|mailbox|user).*not OK/i',
				'/(?:alias|account|recipient|address|email|mailbox|user).*lookup.*fail/i',
				'/(?:recipient|address|email|mailbox|user).*not.*member of domain/i',
				'/(?:alias|account|recipient|address|email|mailbox|user).*cannot be verified/i',
				'/(alias|account|recipient|address|email|mailbox|user).*(n\'t|not)\sexist/six',
				'/not have an account/i',
				'/(?:alias|account|recipient|address|email|mailbox|user).*is not allowed/i',
				'/inactive.*(?:alias|account|recipient|address|email|mailbox|user)/i',
				'/(?:alias|account|recipient|address|email|mailbox|user).*Inactive/i',
				'/(?:alias|account|recipient|address|email|mailbox|user) closed due to inactivity/i',
				'/(?:alias|account|recipient|address|email|mailbox|user) not activated/i',
				'/(?:alias|account|recipient|address|email|mailbox|user).*(?:suspend|expire)/i',
				'/(?:alias|account|recipient|address|email|mailbox|user).*no longer exist/i',
				'/(?:alias|account|recipient|address|email|mailbox|user).*restrict/i',
				'/(?:alias|account|recipient|address|email|mailbox|user).*locked/i',
				'/(?:alias|account|recipient|address|email|mailbox|user) refused/i',
				'/(?:alias|account|recipient|address|email|mailbox|user)(.*)invalid/i',
				'/bad.*(?:alias|account|recipient|address|email|mailbox|user)/i',
				'/Delivery to the following recipients failed/i',
				'/User unknown/i',
				'/.*?.*no such address here/i',
				'/.*?.*?.*user unknown/i',
				'/.*?.*no mailbox/i',
				'/.*?.*?.*can\'t find.*mailbox/i',
				'/.*=D5=CA=BA=C5=B2=BB=B4=E6=D4=DA/i',
				'/.*?.*Unrouteable address/i',
				'/Invalid.*(?:alias|account|recipient|address|email|mailbox|user).*/i',
				'/.*No such.*(?:alias|account|recipient|address|email|mailbox|user)>/i',
				'/.*?.*(?:alias|account|recipient|address|email|mailbox|user).*no.*accept.*mail>/i',
				'/sorry\sto\shave\sto\sinform\syou\sthat\syour\smessage\scould\snot/six',
				'/destin\.\sSconosciuto/i',
				'/Destinatario\serrato/i',
				'/Destinatario\ssconosciuto\so\smailbox\sdisatttivata/i',
				'/Indirizzo\sinesistente/i',
				'/nie\sistnieje/i',
				'/Nie\sma\stakiego\skonta/i',
				'/Esta\scasilla\sha\sexpirado\spor\sfalta\sde\suso/i',
				'/Adressat\sunbekannt\soder\sMailbox\sdeaktiviert/i',
				'/Destinataire\sinconnu\sou\sboite\saux\slettres\sdesactivee/i',
				'/El\susuario\sesta\sen\sestado:\sinactivo/i',
				'/Podane\skonto\sjest\szablokowane\sadministracyjnie\slub\snieaktywne/i',
				'/Questo\sindirizzo\se\'\sbloccato\sper\sinutilizzo/i',
				'/Wiadomosc\szostala\sodrzucona\sprzez\ssystem\santyspamowy/i',
				'/was not delivered to/i',
				'/This is a permanent error/i',
				'/Remote host said: 550 5\.1\.1 No such user/i',
				'/PERM_FAILURE:/i',
				'/UNKNOWN_USER: No such user/i',
				'/mailbox unavailable/i',
				'/Requested action not taken: mailbox unavailable/i',
				'/Action: failed/i',
				'/User unknown in virtual alias table/i',
				'/invalid mailbox/i',
				'/invalid address/i',
				'/user unknown/i',
				'/permanent fatal errors/i',
				'/No mailbox here by that name/i',
				'/User not known/i',
				'/Remote host said: 553/i',
				'/No such (user|recipient)/i',
				'/unknown user/i',
				'/mailbox not found/i',
				'/No such user here/i',
				'/unknown or illegal alias/i',
				'/not listed in domino directory/i',
				'/unrouteable address/i',
				'/Destination server rejected recipients/i',
				'/unable to validate recipient/i',
				'/No such virtual user here/i',
				'/The recipient cannot be verified/i',
				'/bad address/i',
				'/Recipient unknown/i',
				'/recipient rejected/i',
				'/invalid recipient/i',
				'/not our customer/i',
				'/Unknown account/i',
				'/This user doesn\'t have a/i',
				'/no users here by that name/i',
				'/account closed/i',
				'/user not found/i',
				'/This address no longer accepts mail/i',
				'/does not like recipient/i',
				'/Delivery to the following recipient failed permanently/i',
				'/User Does Not Exist/i',
				'/The mailbox is not available on this system/i',
				'/mailbox (.*) (does not|doesn\'t) exist/i',
				'/not a valid mailbox/i',
				'/server doesn\'t handle mail for that user/i',
				'/No such account/i',
				'/unknown recipient/i',
				'/user invalid/i',
				'/User reject the mail/i',
				'/The following recipients are unknown/i',
				'/name or service not known/i',
				'/I couldn\'t find any host named/i',
				'/message could not be delivered for \d+ days/i',
				'/I couldn\'t find a mail exchanger or IP address/i',
				'/address (does not|doesn\'t) exist/i',
				'/Although I\'m listed as a best-preference MX or A for that host/i',
				'/mail server permanently rejected message/i',
				'/bad address syntax/i',
				'/No DNS information was found/i',
				'/unavailable to take delivery of the message/i',
				'/550 5\.1\.1 User unknown/i',
				'/said: 553 sorry,/i',
				'/(does not|doesn\'t) exist/i',
				'/User unknown in virtual mailbox/i',
				'/User is unknown/i',
				'/Unrouteable address/i',
				'/This address does not receive mail/i',
				'/Recipient no longer on server/i',
				'/retry timeout exceeded/i',
				'/retry time not reached for any host after a long failure period/i',
				'/unknown address or alias/i',
				'/Recipient address rejected/i',
				'/Address (rejected|invalid)/i',
				'/Unknown local(\-)?part/i',
				'/bad destination email address/i',
				'/deactivated due to abuse/i',
				'/no such address/i',
				'/user_unknown/i',
				'/recipient not found/i',
				'/User unknown in local recipient table/i',
				'/This recipient e-mail address was not found/i',
				'/no valid recipients/i',
				'/This user doesn\'t have a yahoo/i',
				'/mailbox not available/i',
				'/not a valid user/i',
				'/Unknown destination address/i',
				'/Unknown address error/i',
				'/recipient\'s account is disabled/i',
				'/Unable to chdir to maildir/i',
				'/undeliverable to the following/i',
				'/invalid domain mailbox user/i',
				'/Permanent error in automatic homedir creation/i',
				'/Invalid or unknown virtual user/i',
				'/has not been delivered/i',
				'/Not a valid recipient/i',
				'/Please check the recipients e-mail address/i',
				'/email has changed/i',
				'/This address is no longer valid/i',
				'/unknown email address/i',
				'/no longer in use/i',
				'/not have a final email delivery point/i',
				'/non esiste/i',
				'/no recipients/i',
				'/permanent fatal delivery/i',
				'/address is not valid/i',
				'/unavailable mailbox/i',
				'/account (does not|doesn\'t) exist/i',
				'/The recipient name is not recognized/i',
				'/no such user here/i',
				'/There is no user by that name/i',
				'/No such mailbox/i',
				'/not a recognised email account/i',
				'/address is no longer active/i',
				'/Unable to find alias user/i',
				'/sorry, no mailbox/i',
				'/doesn\'t have an account/i',
				'/not a valid email account/i',
				'/I have now left/i',
				'/I am no longer with/i',
				'/Invalid final delivery user/i',
				'/no longer available/i',
				'/unknown address/i',
				'/isn\'t in my list of allowed recipients/i',
				'/recipients are invalid/i',
				'/recipient is invalid/i',
				'/mailbox is not valid/i',
				'/invalid e-mail address/i',
				'/doesn\'t_have_a_yahoo/i',
				'/not known at this site/i',
				'/email name is not found/i',
				'/address doesn\'t exist/i',
				'/destination addresses were unknown/i',
				'/no existe/i',
				'/does not have an email/i',
				'/_does_not_exist_here/i',
				'/User unknown in virtual mailbox table/i',
				'/user is no longer available/i',
				'/unknown user account/i',
				'/Addressee unknown/i',
				'/user (does not|doesn\'t) exist/i',
				'/554 delivery error: This user doesn\'t have/i',
				'/No such domain at this location/i',
				'/an MX or SRV record indicated no SMTP service/i',
				'/I couldn\'t find any host by that name/i',
				'/Domain (does not|doesn\'t) exist; please check your spelling/i',
				'/Domain not used for mail/i',
				'/Domain must resolve/i',
				'/unrouteable mail domain/i',
				'/no route to host/i',
				'/host not found/i',
				'/Host or domain name not found/i',
				'/illegal host\/domain/i',
				'/bad destination host/i',
				'/no matches to nameserver query/i',
				'/no such domain/i',
				'/Cannot resolve the IP address of the following domain/i',
				'/5\.7\.1 Unable to deliver to/i',
				'/message could not be delivered/i',
				'/dns loop/i',
				'/domain missing or malformed/i',
				'/550_Invalid_recipient/i',
				'/Invalid Address/i',
				'/Bad destination mailbox address/i',
				'/Remote host said: 550 5\.1\.1 No such user/i',
				'/This is a permanent error/i',
				'/this user doesn\'t have a yahoo\.com account/i',
				'/bad address/i',
				'/Unknown account/i',
				'/This user doesn\'t have a/i',
				'/No such account/i',
				'/550 5\.1\.1 User unknown/i',
				'/(does not|doesn\'t) exist/i',
				'/Unknown local-part/i',
				'/This recipient e-mail address was not found/i',
				'/Your e-mail has not been delivered/i',
				'/Please check the recipients e-mail address/i',
				'/I have now left/i',
				'/invalid e-mail address/i',
				'/illegal (host|domain)/i',
				'/This mail server requires authentication when attempting to send to a non-local e-mail address/i',
				'/5\.7\.1 Unable to deliver to/i',
				'/RESOLVER\.ADR\.RecipNotFound; not found/i',
				'/Unable to relay recipient in non-accepted domain/i',
				'/smtp;(\s*)?550(.*)?Relaying denied/i',
				'/The recipient server did not accept our requests to connect/i',
				'/No mail servers appear to exists/i',
			),
		),
	),
);
